// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   uniform mat4 agk_WorldViewProj;
   uniform mat4 agk_World;
   uniform mat3 agk_WorldNormal;
   uniform vec3 agk_CameraPos;
   uniform vec4 uvBounds0;

//--------------
// tweaks
//--------------
   uniform mat4 ShadowsProj;
   uniform vec3 ShadowsSize;

//--------------
// Textures
//-------------- 
    uniform sampler2D texture6; // Shadowmap

//--------------
// attributes
//--------------
    attribute vec3 position;
    attribute vec2 uv;
    attribute vec3 normal;
    attribute vec3 tangent;

//--------------
// Vs Out
//--------------
    varying vec2 Vs_Tex;
    varying vec3 Vs_TBNRow1;
    varying vec3 Vs_TBNRow2;
    varying vec3 Vs_TBNRow3;
    varying vec3 Vs_WorldPos;
    varying vec3 Vs_ViewVec;
    varying vec4 Vs_Proj;
    varying float Vs_Shadows;

//--------------
// vertex shader
//--------------
   void main()
     {
	vec4 Pos=agk_WorldViewProj*vec4(position,1.0);
	gl_Position=Pos;
	Vs_Tex=uv*uvBounds0.xy+uvBounds0.zw;
	vec3 Normals=normalize(agk_WorldNormal*normal);
	vec3 Tangent=normalize(agk_WorldNormal*tangent);
	Vs_TBNRow1=Tangent;
	Vs_TBNRow2=cross(Normals,Tangent);
	Vs_TBNRow3=Normals;
	vec3 WorldPos=(agk_World*vec4(position,1.0)).xyz;
	Vs_WorldPos=WorldPos;
	vec3 ViewVec=agk_CameraPos-WorldPos;
	Vs_ViewVec=ViewVec;
        Vs_Proj=vec4(Pos.x*0.5+0.5*Pos.w,Pos.y*0.5+0.5*Pos.w,Pos.z,Pos.w);
   	vec4 LightProj=(ShadowsProj*vec4(WorldPos,1.0))*vec4(0.5,-0.5,1.0,1.0)+vec4(0.5,0.5,0.0,0.0);
        vec4 ShadowMap=vec4(textureLod(texture6,LightProj.xy,0.0).x,textureLod(texture6,LightProj.xy+ShadowsSize.yz,0.0).x,textureLod(texture6,LightProj.xy+ShadowsSize.zy,0.0).x,textureLod(texture6,LightProj.xy+ShadowsSize.yy,0.0).x);
	ShadowMap=step(ShadowMap,1.00005-LightProj.zzzz); 
	ShadowMap.xy=mix(ShadowMap.xz,ShadowMap.yw,fract(ShadowsSize.x*LightProj.x));
	Vs_Shadows=mix(ShadowMap.x,ShadowMap.y,fract(ShadowsSize.x*LightProj.y));
     }
